<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/Menu.php";
    include "../classi/GeneratoreUrl.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb      = new DbManager($costantiDatabase);
    $operazione    = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    $datiGeecomAsk = $geecomDb->leggiSingolaRiga("geec_prodotti", 1);
    $percorsoAreaAmministrativa = str_replace("../","",$datiGeecomAsk["percorso"]);
    session_start();

    $menu = new Menu($geecomDb, filter_input(INPUT_POST, "id"));
    switch ($operazione) {
        case 'crea':
            $menu->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $menu->setFormRicerca(filter_input(INPUT_POST,"formRicerca",FILTER_SANITIZE_STRING));
            $menu->crea();
            header("Location: ../$percorsoAreaAmministrativa/creaMenu.php?id={$menu->getId()}&status=200");
            break;
        case 'modifica':
            $menu->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
            $menu->setFormRicerca(filter_input(INPUT_POST,"formRicerca",FILTER_SANITIZE_STRING));
            $menu->modifica();
            header("Location: ../$percorsoAreaAmministrativa/creaMenu.php?id={$menu->getId()}&status=250");
            break;
        case 'elimina':
            $menu->elimina();
            echo "ok";
            break;
        case 'creaVoceMenu':
            $tipo  = filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_STRING);
            $idContenuto  = filter_input(INPUT_POST, "idContenuto",FILTER_SANITIZE_STRING);
            $nome  = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $icona = filter_input(INPUT_POST, "icona",FILTER_SANITIZE_STRING);
            $link  = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $vocePadre = filter_input(INPUT_POST, "vocePadre",FILTER_SANITIZE_NUMBER_INT);
            $gruppoSpecifico = filter_input(INPUT_POST, "gruppoSpecifico",FILTER_SANITIZE_NUMBER_INT);
            echo $menu->creaVoceMenu($tipo,$idContenuto, $nome, $link, $icona,$vocePadre,$gruppoSpecifico);
            break;
        case 'spostaVoceMenu':
            $menu->spostaVoce(filter_input(INPUT_POST, "idVoce",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaVoceMenu':
            $idElemento      = filter_input(INPUT_POST,"idVoceMenu",FILTER_SANITIZE_STRING);
            $idContenuto     = filter_input(INPUT_POST, "idContenuto",FILTER_SANITIZE_STRING);
            $tipo            = filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_STRING);
            $nome            = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $icona           = filter_input(INPUT_POST, "icona",FILTER_SANITIZE_STRING);
            $link            = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $gruppoSpecifico = filter_input(INPUT_POST, "gruppoSpecifico",FILTER_SANITIZE_NUMBER_INT);
            $menu->modificaVoceMenu($idElemento,$idContenuto,$tipo, $nome, $link, $icona,$gruppoSpecifico);
            echo"ok";
            break;
        case 'aggiornaDatiMegaMenu':
            $idVoceMegaMenu    = filter_input(INPUT_POST, "idVoceMegaMenu",FILTER_SANITIZE_STRING);
            $testoAssociato    = filter_input(INPUT_POST, "testoAssociato",FILTER_SANITIZE_STRING);
            $mostraNomiColonne = filter_input(INPUT_POST, "mostraNomiColonne",FILTER_SANITIZE_STRING);
            $menu->aggiornaDatiMegaMenu($idVoceMegaMenu,$testoAssociato,$mostraNomiColonne);
            echo "ok";
            break;
        case 'eliminaVoceMenu':
            $menu->eliminaVoceMenu(filter_input(INPUT_POST, "idVoceMenu",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'stampaVociMenu';
            $menu->stampaVociMenu();
            break;
    }